import pandas as pd

# Read the two tables
df_label = pd.read_csv("label_data.csv")
df_notifications = pd.read_csv("notification_data.csv")

# Ensure the date columns have the same format
# If the date is in string format, convert it to datetime format
df_label['date_day'] = pd.to_datetime(df_label['date_day'])
df_notifications['NOTIFICATION_SENT'] = pd.to_datetime(df_notifications['NOTIFICATION_SENT'])

# Merge the two tables on STUDY_PRTCPT_ID and date
# The merge type is an inner join to ensure only matching data is kept
merged_df = pd.merge(
    df_label,
    df_notifications,
    left_on=['STUDY_PRTCPT_ID', 'date_day'],
    right_on=['STUDY_PRTCPT_ID', 'NOTIFICATION_SENT'],
    how='inner'
)

# Check the structure of the merged data
# Extract the necessary columns, keeping variables like STEP_COUNT, SLEEP_COUNT, MOOD, etc.
result_df = merged_df[[
    'STUDY_PRTCPT_ID',
    'date_day',
    'study_week',
    'STEP_COUNT',
    'SLEEP_COUNT',
    'MOOD',
    'NOTIFICATION_SENT',
    'NOTIFICATION_ID',
    'STUDY_ID',
    'NOTIFICATION_WAS_SENT',
    'CONTENT_TYPE',
    'NOTIFICATION_TYPE',
    'NOTIFICATION_CONTENT',
    'NOTIFICATION_ALT_CONTENT',
    'NOTIFICATION_CATEGORY',
    'week_category'
]]

# Save the result to a CSV file
result_df.to_csv("merged_result.csv", index=False)

print("Data processing is complete, the result has been saved as merged_result.csv")
